library(scales)

figureDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 4 - Oyster settlement plates/Figure components/'
csvDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 4 - Oyster settlement plates/CSV/'

setwd(csvDirectory)
d = read.csv("Oyster settlement plates.csv")

totalbiomass.g = as.numeric(tapply(d$biomass.g,d$inun,sum))
inundFreq = as.numeric(tapply(d$inun,d$inun,unique))
cageArea.m2 = as.numeric(tapply(d$area, d$inun, sum))
biomass.g_m2 = totalbiomass.g/cageArea.m2

filter = biomass.g_m2 > 0
m1 = lm(log(biomass.g_m2[filter]) ~ inundFreq[filter])
m2 = lm(log(biomass.g_m2[filter]) ~ log(inundFreq[filter]))
AIC(m1,m2)

tiff('Figure 4a.tiff', width = 17, height = 13, units = "cm", res = 300)
par(mar = c(5,5,4,4))
plot(biomass.g_m2[filter] ~ inundFreq[filter], log = 'yx', 
     yaxt = 'n', cex = 1, cex.lab=  1.2, cex.axis = 1,
     ylim = c(0.1, 10000), xlim = c(40,70), 
     pch = 22, bg = alpha('red',0.5),
     ylab = expression(paste('Oyster settlement biomass ','(g m'^'-2',')')), 
     xlab = 'Inundation frequency (%)')
axis(side = 2, at = 10^(-10:10), labels = 10^(-10:10), cex.axis = 1)
a1 = m1$coefficients[1]
b1 = m1$coefficients[2]
a2 = m2$coefficients[1]
b2 = m2$coefficients[2]
xv = seq(min(inundFreq[filter]), max(inundFreq[filter]), length.out = 1000)
yv1 = exp(a1 + xv*b1)
yv2 = exp(a2 + log(xv)*b2)
lines(yv2 ~ xv, lwd = 2, col = alpha('black',1))

summary(m1)
summary(m2)

text(y = 8000, x = 53, expression(paste('(','F'['1,12'],' = 239.1, n = 14, ', 'R'^'2', '= 0.948, p < 0.001)')), cex = 1)
setwd(figureDirectory)
dev.off()
